<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Karigarctrl extends CI_Controller {
	public $karigarmdl;
	public $pagination;

	public function __construct()
	{
		parent::__construct();

		$this->load->model('karigarmdl');
		$this->load->library('session');
		$this->load->library('upload');
		$this->load->library('pagination');
		$this->config->load('extra');
		$this->load->library('db_operations');
	}

	public function index()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$this->load->view('pages/master/index');
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}
	}

	public function send_sms($mob,$msg)
    {
        
		$xml_data ='<?xml version="1.0"?>
		<parent> 
		<child>
		<user>Interlin</user>
		<key>f13788bc58XX</key>
		<mobile>'.$mob.'</mobile>
		<message>'.$msg.'</message>
		<accusage>1</accusage>
		<senderid>STYLO FASHION</senderid>
		</child>
		</parent>';
		// print_r($xml_data);exit;
		$URL = "http://sms.interlinkconsultant.com/submitsms.jsp?"; 

		$ch = curl_init($URL);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
		curl_setopt($ch, CURLOPT_POSTFIELDS, "$xml_data");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$output = curl_exec($ch);
		curl_close($ch);
		// print_r($output);
		$output_array = explode(",", $output);
		if($output_array[1]=="success")
		{
			echo 1;
		}
		else
		{
			echo 4;
		}
       
    }
    
    public function send_sms_for_order($mob,$msg)
    {
		$xml_data ='<?xml version="1.0"?>
		<parent> 
		<child>
		<user>Interlin</user>
		<key>f13788bc58XX</key>
		<mobile>'.$mob.'</mobile>
		<message>'.$msg.'</message>
		<accusage>1</accusage>
		<senderid>STYLO FASHION</senderid>
		</child>
		</parent>';
		// print_r($xml_data);exit;
		$URL = "http://sms.interlinkconsultant.com/submitsms.jsp?"; 

		$ch = curl_init($URL);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
		curl_setopt($ch, CURLOPT_POSTFIELDS, "$xml_data");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$output = curl_exec($ch);
		curl_close($ch);
		// print_r($output);
    }

	public function karigar()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			if($_GET['ac'] == "view") 
			{
				$config = array();
				$this->config->load('extra');
				$config = $this->config->item('pagination');
				$config['per_page'] = 200;
				
				$config['total_rows'] = $this->karigarmdl->get_karigar_data_count($_SESSION['fin_year']);
				$config['base_url']   = base_url('karigarctrl/karigar?search=true');

				foreach ($_GET as $key => $value) {
		            if ($key != 'search' && $key != 'offset') {
		                $config['base_url'] .= '&' . $key . '=' . $value;
		            }
		        }

		        $offset = (!empty($_GET['offset'])) ? $_GET['offset'] :  0;

		        $this->pagination->initialize($config);

				$record 	= $this->karigarmdl->get_karigar_data($_SESSION['fin_year'],$config['per_page'],$offset);
				$record['count'] 		= $offset;
				$record['total_rows'] 	= $config['total_rows'];
				$record['search_data'] 	= $this->config->item('karigar_search');

				// echo "<pre>";print_r($record);exit();
				$this->load->view('pages/karigar/karigar_master',$record);
			}
			else if ($_GET['ac'] == "add") 
			{
				$record = $this->karigarmdl->get_data_for_karigar_entry($_SESSION['fin_year']);
				// echo "<pre>";print_r($record);exit();
				$this->load->view('pages/karigar/karigar_form',$record);

			}
			else if ($_GET['ac'] == "update") 
			{
				$id 		= $_GET['id'];
                $km_id 	= encrypt_decrypt("decrypt", $id, SECRET_KEY);

                if (!empty($km_id)) {

                	$record = $this->karigarmdl->get_single_karigar_data_for_update($km_id);
                	// echo "<pre>";print_r($record);exit();
					$this->load->view('pages/karigar/karigar_form',$record);
                } else {
					$this->load->view('errors/error');
                }
			}
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function karigar_insert($km_id)
	{
		if (sessionExist()) 
		{			
			$form_data = $this->input->post();
			// echo "<pre>";print_r($form_data);exit();
			$file_data = array();
					
			$file_data = $_FILES;
			if($_FILES['km_photo']['error'] == 0) 
			{
				$filename = time().'_'.$_FILES['km_photo']['name'];
				$filename = str_replace(" ", "_", $filename);

				$config['upload_path']     = 'public/uploads/product/';
            	$config['allowed_types']   = 'gif|jpg|png|pdf';
            	$config['file_name']       =  $filename;	
      
            	$this->upload->initialize($config);

            	if (!$this->upload->do_upload('km_photo')) 
            	{
            		$file_data['filename'] = 'no_image.jpg';
            	}
            	else
            	{
            		$file_data['filename'] = $filename;
            	}
			}
			else
			{
				$file_data['filename'] 	= $form_data['km_photo_update'];
			}

			/*karigar master data array*/
			$karigar_data = array();
			
			$karigar_data['km_name'] 		= $form_data['km_name'];
			$karigar_data['km_doj'] 		= date('Y-m-d',strtotime($form_data['km_doj']));
			$karigar_data['km_mob'] 		= $form_data['km_mob'];
			$karigar_data['km_cat'] 		= $form_data['km_cat'];
			$karigar_data['km_refference'] 	= $form_data['km_refference'];
			$karigar_data['km_desig'] 		= $form_data['km_desig'];
			$karigar_data['km_addr'] 		= $form_data['km_addr'];

			$karigar_data['km_photo'] 		= $file_data['filename'];

			if ($km_id == 0) 
			{
				$this->db->trans_begin();
				/*check duplicate purchase entry no*/
				$cnt = $this->karigarmdl->check_duplicate_karigar_entry($form_data['km_name'],$_SESSION['fin_year']);

				if ($cnt != 0) 
				{
					echo 2;
				}
				else
				{
					
					$karigar_data['km_userid'] 			= $_SESSION['user_id'];				
					$karigar_data['km_cdate'] 			= date('Y-m-d');				
					$karigar_data['km_modify_userid'] 	= $_SESSION['user_id'];				

					/*insert data to karigar_master table*/
					$result_id = $this->db_operations->data_insert('karigar_master', $karigar_data);
					
					if (!empty($result_id)) {
						/*insert data to karigar_trans table*/
						$kt_result 	= $this->insert_update_karigar_trans($form_data, $result_id);
					}

					if ($this->db->trans_status() === FALSE) {
					    $this->db->trans_rollback();
					    echo 0;
					} else {
					    $this->db->trans_commit();

					    $resp = array();
						$km_id_print = encrypt_decrypt("encrypt", $result_id, SECRET_KEY);

						$resp['flag'] = 1;
						$resp['km_id'] = $km_id_print;

						echo json_encode($resp);
					}			
				}
			}
			else
			{
				$this->db->trans_begin();
				/*update code*/
				$edit_cnt = $this->karigarmdl->check_edit_duplicate_karigar_entry($form_data['km_name'],$_SESSION['fin_year'],$km_id);

				if ($edit_cnt != 0) 
				{
					echo 2;
				}
				else
				{
					$karigar_data['km_modify_userid'] 	= $_SESSION['user_id'];		

					// echo "<pre>";print_r($karigar_data);exit();

					/*update data to karigar_master table*/
					$result = $this->db_operations->data_update('karigar_master', $karigar_data, 'km_id', $km_id);

					if (!empty($result)) 
					{
						/*update data to karigar_trans table*/
						$kt_result 	= $this->insert_update_karigar_trans($form_data, $km_id);
					}

					if ($this->db->trans_status() === FALSE) {
					    $this->db->trans_rollback();
					    echo 0;
					} else {
					    $this->db->trans_commit();
						$resp = array();
						$resp['flag'] = 1;
						echo json_encode($resp);
					}	
				} 
			}
		} 
		else 
		{
			redirect('loginctrl/logout');
		}
	}


	public function insert_update_karigar_trans($form_data,$km_id)
	{	
		// 0 = not avialable
		// 1 = avialable
		$karigar_trans_data = $this->db_operations->get_record('karigar_transaction',array('kt_km_id' =>$km_id)); // get all db record first and all form data and match who is missing and those data delete by system  

		foreach ($karigar_trans_data as $key => $value) 
		{
			if (!in_array($value['kt_id'], $form_data['kt_id'])) 
			{	
				/*delete transactions*/
				$del_res = $this->db_operations->delete_record('karigar_transaction',array('kt_id' =>$value['kt_id']));
			}
		}

		foreach ($form_data['kt_id'] as $key => $value) 
		{
			/*karigar transaction data*/
			$karigar_trans = array();
			
			$karigar_trans['kt_km_id'] 		= $km_id;
			$karigar_trans['kt_app_id'] 	= $form_data['kt_app_id'][$key];
			$karigar_trans['kt_app_name'] 	= $form_data['kt_app_name'][$key];
			$karigar_trans['kt_app_charges'] = $form_data['kt_app_charges'][$key];

			if ($value == 0) 
			{
				/*karigar transaction insert process*/
				$karigar_trans_result = $this->db_operations->data_insert('karigar_transaction', $karigar_trans);
			} 
			else 
			{
				/*karigar transaction update process*/
				$karigar_trans_result = $this->db_operations->data_update('karigar_transaction',$karigar_trans,'kt_id',$value);
			}
		}
	}


	public function karigar_delete($km_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			/*db transaction starts*/
			$this->db->trans_begin();

			/*delete karigar records*/
			$this->db_operations->delete_record('karigar_master', array('km_id' => $km_id));
			$this->db_operations->delete_record('karigar_transaction', array('kt_km_id' => $km_id));
			/*delete karigar voucher */
		
			if ($this->db->trans_status() === FALSE) {
			    $this->db->trans_rollback();
			    echo 0;
			} else {
			    $this->db->trans_commit();
				echo 1;
			}	
		} 
		else 
		{
			redirect('loginctrl/logout');
		}
	}

/************************************ JOB PROCESS START ****************************************************************/
	
	public function job()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			if ($_GET['ac'] == 'view') 
			{
				$config = array();
				$this->config->load('extra');
				$config = $this->config->item('pagination');
				$config['per_page'] = 20;
				
				$ristricted_date = '2019-03-31';

				$row_data = $this->karigarmdl->get_all_job_master_rows($ristricted_date);
				// echo "<pre>";print_r($row_data);exit();

				$config['total_rows'] = $row_data['jm_count'];

				$config['base_url']   = base_url('karigarctrl/job?search=true');

				foreach ($_GET as $key => $value) {
		            if ($key != 'search' && $key != 'offset') {
		                $config['base_url'] .= '&' . $key . '=' . $value;
		            }
		        }

		        $offset = (!empty($_GET['offset'])) ? $_GET['offset'] :  0;

		        $this->pagination->initialize($config);

				$record 	= $this->karigarmdl->get_all_job_master_data($ristricted_date,$config['per_page'],$offset);
				$record['count'] 		= $offset;
				$record['total_rows'] 	= $config['total_rows'];
				$record['search_data'] 	= $this->config->item('order_search');

				// echo "<pre>";print_r($record);exit();
				
				$this->load->view('pages/karigar/job_master',$record);
			}
		}
		else
		{
			redirect('loginctrl/logout');
		}
	}

	public function jobdone()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			if ($_GET['ac'] == 'view') 
			{
				$config = array();
				$this->config->load('extra');
				$config = $this->config->item('pagination');
				$config['per_page'] = 200;
				
				$ristricted_date = '2019-03-31';

				$row_data = $this->karigarmdl->get_all_job_done_rows($ristricted_date);
				// echo "<pre>";print_r($row_data);exit();

				$config['total_rows'] = $row_data['jm_count'];

				$config['base_url']   = base_url('karigarctrl/jobdone?search=true');

				foreach ($_GET as $key => $value) {
		            if ($key != 'search' && $key != 'offset') {
		                $config['base_url'] .= '&' . $key . '=' . $value;
		            }
		        }

		        $offset = (!empty($_GET['offset'])) ? $_GET['offset'] :  0;

		        $this->pagination->initialize($config);

				$record 	= $this->karigarmdl->get_all_job_done_data($ristricted_date,$config['per_page'],$offset);
				$record['count'] 		= $offset;
				$record['total_rows'] 	= $config['total_rows'];
				$record['search_data'] 	= $this->config->item('order_search');

				// echo "<pre>";print_r($record);exit();
				$this->load->view('pages/karigar/job_done_master',$record);
			}
		}
		else
		{
			redirect('loginctrl/logout');
		}
	}

	public function get_karigar_details($km_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->karigarmdl->get_karigar_record($km_id);
			// echo "<pre>";print_r($record);exit();
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function get_karigar_order_data($app_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->karigarmdl->get_karigar_order_trans_data($app_id,$_SESSION['fin_year']);
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}
	
	public function get_karigar_order_details($ot_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$data = $this->karigarmdl->get_karigar_order_trans_details($ot_id);

			// echo "<pre>";print_r($data);exit();

			echo json_encode($data);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}
 
	/**************** for rreset order job ***********************/
	
	public function get_karigar_hisab_status($ot_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->karigarmdl->get_karigar_chart_hisab_status($ot_id);
			// echo "<pre>";print_r($record);exit();
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}


	public function get_karigar_job_order_data($km_id,$ot_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->karigarmdl->get_karigar_job_order_data($km_id,$ot_id);
			// echo "<pre>";print_r($record);exit();
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function update_job_status($ot_id,$karigar_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$form_data = $this->input->post();
			// echo "<pre>";print_r($form_data);exit();
			$km_valid = $this->karigarmdl->check_if_karigar_workon_this_apparel($ot_id,$karigar_id);

			// echo "<pre>";print_r($km_valid);exit();
			if ($km_valid == 0) 
			{
				echo 3;
			}
			else
			{
				$reset_staus = $form_data['ot_reset_status'];

				if ($reset_staus == 0) 
				{
					$job_data = array();

					$job_data['ot_km_id'] 					= 0;
					$job_data['ot_current_status'] 			= 0;
					$job_data['ot_issue_status'] 			= 0;
					$job_data['ot_received_status'] 		= 0;
					$job_data['ot_trial_issue_status'] 		= 0;
					$job_data['ot_trial_received_status'] 	= 0;
					$job_data['ot_done_status'] 			= 0;

					$job_data['ot_issue_date'] 				= '0000-00-00';
	                $job_data['ot_received_date'] 			= '0000-00-00';
	                $job_data['ot_trial_issue_date'] 		= '0000-00-00';
	                $job_data['ot_trial_received_date'] 	= '0000-00-00';
	                $job_data['ot_done_date'] 				= '0000-00-00';

				}
				else if ($reset_staus == 1) 
				{
					$job_data = array();
					
					$job_data['ot_current_status'] 			= 1;
					$job_data['ot_issue_status'] 			= 1;
					
					$job_data['ot_received_status'] 		= 0;
					$job_data['ot_trial_issue_status'] 		= 0;
					$job_data['ot_trial_received_status'] 	= 0;
					$job_data['ot_done_status'] 			= 0;

					$job_data['ot_received_date'] 			= '0000-00-00';
	                $job_data['ot_trial_issue_date'] 		= '0000-00-00';
	                $job_data['ot_trial_received_date'] 	= '0000-00-00';
	                $job_data['ot_done_date'] 				= '0000-00-00';

				}
				else if ($reset_staus == 2) 
				{
					$job_data = array();
					
					$job_data['ot_current_status'] 			= 2;
					$job_data['ot_received_status'] 		= 1;
					
					$job_data['ot_trial_issue_status'] 		= 0;
					$job_data['ot_trial_received_status'] 	= 0;
					$job_data['ot_done_status'] 			= 0;

	                $job_data['ot_trial_issue_date'] 		= '0000-00-00';
	                $job_data['ot_trial_received_date'] 	= '0000-00-00';
	                $job_data['ot_done_date'] 				= '0000-00-00';

				}
				else if ($reset_staus == 3) 
				{
					$job_data = array();
					
					$job_data['ot_current_status'] 			= 3;
					$job_data['ot_trial_issue_status'] 		= 1;
					
					$job_data['ot_trial_received_status'] 	= 0;
					$job_data['ot_done_status'] 			= 0;

	                $job_data['ot_trial_received_date'] 	= '0000-00-00';
	                $job_data['ot_done_date'] 				= '0000-00-00';

				}
				else if ($reset_staus == 4) 
				{
					$job_data = array();
					
					$job_data['ot_current_status'] 			= 4;
					$job_data['ot_trial_received_status'] 	= 1;
					
					$job_data['ot_done_status'] 			= 0;

	                $job_data['ot_done_date'] 				= '0000-00-00';
				}
				else
				{
					$job_data = array();
					
					$job_data['ot_done_status'] 			= 0;
	                $job_data['ot_done_date'] 				= '0000-00-00';
				}

				$this->db->trans_begin();

				// echo "<pre>";print_r($job_data);exit();

				$result = $this->db_operations->data_update('order_trans', $job_data, 'ot_id', $ot_id);
				
				if ($this->db->trans_status() === FALSE) {
				    $this->db->trans_rollback();
				    echo 0;
				} else {
				    $this->db->trans_commit();
					echo 1;
				}	
			}
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}


	public function order_process_step($ot_id,$karigar_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{	
			$form_data = $this->input->post();
				// echo "<pre>";print_r($form_data);exit();
			

			if ($karigar_id == 0) 
			{
				echo 2;
			}
			else
			{
				$km_valid = $this->karigarmdl->check_if_karigar_workon_this_apparel($ot_id,$karigar_id);

				// echo "<pre>";print_r($km_valid);exit();
				if ($km_valid == 0) 
				{
					echo 3;
				}
				else
				{
					$process_data = array();
					$process = array();
					
					$process_data['ot_issue_status'] = $form_data['ot_issue_status'][0];

					if ($process_data['ot_issue_status'] == 1) 
					{
						$process = array();
						$process['ot_issue_status'] 	= 1;
						$process['ot_issue_date'] 		= date('Y-m-d');
						$process['ot_km_id'] 			= $karigar_id;
						$process['ot_current_status'] 	= $process_data['ot_issue_status'];
					}

					if ($process_data['ot_issue_status'] == 2) 
					{
						$process = array();
						$process['ot_received_status'] 	= 1;
						$process['ot_received_date'] 	= date('Y-m-d');
						$process['ot_km_id'] 			= $karigar_id;
						$process['ot_current_status'] 	= $process_data['ot_issue_status'];
					}

					if ($process_data['ot_issue_status'] == 3) 
					{
						$process = array();
						$process['ot_trial_issue_status'] 	= 1;
						$process['ot_trial_issue_date'] 	= date('Y-m-d');
						$process['ot_km_id'] 				= $karigar_id;
						$process['ot_current_status'] 		= $process_data['ot_issue_status'];
					}

					if ($process_data['ot_issue_status'] == 4) 
					{
						$process = array();
						$process['ot_trial_received_status'] = 1;
						$process['ot_trial_received_date'] 	 = date('Y-m-d');
						$process['ot_km_id'] 				 = $karigar_id;
						$process['ot_current_status'] 		 = $process_data['ot_issue_status'];
					}

					if ($process_data['ot_issue_status'] == 5) 
					{
						$process = array();
						$process['ot_done_status'] 		= 1;
						$process['ot_done_date'] 		= date('Y-m-d');
						$process['ot_km_id'] 			= $karigar_id;
						$process['ot_current_status'] 	= $process_data['ot_issue_status'];
					}	
					/*update data to order_trans table*/
					echo $this->db_operations->data_update('order_trans', $process, 'ot_id', $ot_id);
				}

			}
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

/**************** end karigar controller *************************/
}
?>
