<?php defined('BASEPATH') OR exit('No direct script access allowed');
use Restserver\Libraries\REST_Controller;
require APPPATH . '/libraries/REST_Controller.php';
// require APPPATH . 'libraries/Format.php';
class Users extends \Restserver\Libraries\REST_Controller
{
    public function __construct() { 
        parent::__construct();
        // Load User Model
        $this->load->model('api/user_model', 'UserModel');
        $this->load->library('form_validation');
        $this->load->library('db_operations');
        $this->load->library('validateToken');
    } 

    public function login_post() 
    {  
        header("Access-Control-Allow-Origin: *"); 
        $_POST = $this->security->xss_clean($_POST);
        $input_data = $this->input->raw_input_stream;
        $form_data  = json_decode($input_data, true);
        $API_KEY    = $form_data['api_access_key'];
        // print_r($API_KEY);exit;
        if (API_ACCESS_KEY != $API_KEY)
        {
            $message = ['status' => FALSE,'message' => "1. Signature verification failed",];
            $this->response($message, REST_Controller::HTTP_NOT_FOUND);
            return;
        }

        $post_data = $form_data;
        if (empty($post_data)) {  
            $message = [
                'status' => FALSE,
                'message' => "2. Invalid request.."
            ];
            $this->response($message, REST_Controller::HTTP_NOT_FOUND);
            return;
        }

        $_POST = $this->security->xss_clean($post_data);
        $this->form_validation->set_rules('username', 'Username', 'trim|required');
        $this->form_validation->set_rules('password', 'Password', 'trim|required');
        $this->form_validation->set_rules('mobile_no', 'Mobile No', 'trim|required');
        $this->form_validation->set_rules('fin_year', 'Financial Year', 'trim|required');
        if ($this->form_validation->run() == FALSE)
        {
            $message = array( 
                'status' => false,
                'error' => $this->form_validation->error_array(),
                'message' => validation_errors()
            );
            $this->response($message, REST_Controller::HTTP_OK);
            return;
        }

        $km_data = $this->db_operations->get_record('karigar_master', ['km_mob' => $_POST['mobile_no']]);
        if(empty($km_data))return $this->response(['status' => false, 'message' => '1. Invalid Karigar.'], REST_Controller::HTTP_BAD_REQUEST);

        $desig_data = $this->db_operations->get_record('designation_master', ['designation_id' => $km_data[0]['km_designation']]);
        if(empty($desig_data))return $this->response(['status' => false, 'message' => '1. Invalid Karigar Designation.'], REST_Controller::HTTP_BAD_REQUEST);

        $karigar_record = $this->UserModel->karigar_record($_POST['mobile_no']); 
            if(empty($karigar_record)){
                return $this->response(['status' => false, 'message' => 'Invalid Karigar designation!!!'], REST_Controller::HTTP_NOT_FOUND);
            }

        $output = $this->UserModel->user_login($_POST['username'],$_POST['password']);
        if(empty($output) || $output == FALSE) 
        {
            $message = ['status' => FALSE,'message' => "Invalid Credentials"];
            $this->response($message, REST_Controller::HTTP_OK);
            return;
        }

        if($output[0]['user_status'] != 1){ 
            $message = ['status' => FALSE,'message' => 'Account has been deactivated.'];
            $this->response($message, REST_Controller::HTTP_OK);
            return;
        }

        // Generate Token
        
        $token_data['uuid']                 = $output[0]['user_id'].''.time();
        $token_data['user_id']              = $output[0]['user_id'];
        $token_data['user_role_id']         = $output[0]['user_role_id'];
        $token_data['karigar_id']           = $km_data[0]['km_id'];
        $token_data['karigar_name']         = $km_data[0]['km_name'];
        $token_data['process_id']           = $desig_data[0]['designation_id'];
        $token_data['process_name']         = $desig_data[0]['designation_name'];
        $token_data['user_name']            = $output[0]['user_name'];
        $token_data['fin_year']             = $_POST['fin_year'];
        $token_data['start_year']         = $this->get_fin_year($post_data['fin_year']);
        $token_data['end_year']           = $this->get_fin_year($post_data['fin_year'], false);
        $token_data['time']                 = strtotime('+2 days'); 

        $user_token = $this->validatetoken->generateToken($token_data);
        // print_r($output);die;
        $return_data = [
            'user_id'           => $output[0]['user_id'],
            'user_role_id'      => $output[0]['user_role_id'],
            'user_name'         => $output[0]['user_name'],
            'karigar_id'        =>  $km_data[0]['km_id'],
            'karigar_name'      =>  $km_data[0]['km_name'],
            'process_id'        =>  $desig_data[0]['designation_id'],
            'process_name'      => $desig_data[0]['designation_name'],
            'fin_year'          => $_POST['fin_year'],
            'start_year'        =>$this->get_fin_year($post_data['fin_year']),
            'end_year'          =>$this->get_fin_year($post_data['fin_year'], false),
            'token_auth'        => $user_token,
        ];
        // Login Success 
        //  echo "<pre>";print_r($token_data);die;
        $this->db->trans_begin();   
        if($this->db_operations->data_update('user_master',['user_token_auth'=>$user_token,'user_uuid'=>$token_data['uuid']],'user_id',$output[0]['user_id'])<1){
            $this->db->trans_rollback();
            $message = ['status' => FALSE,'message' => "Token not generated."];
            $this->response($message, REST_Controller::HTTP_OK);
            return;
        }
        
        if($this->db->trans_status()===FALSE){
            $message = ['status' => FALSE,'message' => 'Something Wrong Please try again !!'];
            $this->response($message, REST_Controller::HTTP_NOT_FOUND);
            return;
        }

        $this->db->trans_commit();
        $message = ['status'    => true,'data' => $return_data,'message'   => "User login successful"];
        $this->response($message, REST_Controller::HTTP_OK);
    }

    public function get_fin_year($fin_year, $start = true){ 
        $explode = explode('-', $fin_year);
        if($start) return $explode[0].'-04-01'; // 2020-04-01
        return $explode[1].'-03-31'; // 2021-03-31
    }

    public function user_login_token_auth_update_post(){      
        
        header("Access-Control-Allow-Origin: *");
        $token_data = $this->validatetoken->middleware(['validateAccessKey','validateToken']);
        if($token_data['status']!==TRUE){ 
            $this->response($token_data, REST_Controller::HTTP_NOT_FOUND);
            return;
        }
        
        $user_id                      = $token_data['data']['user_id'];
        $token_data['uuid']           = $token_data['data']['uuid'];
        $token_data['user_id']        = $token_data['data']['user_id'];
        $token_data['user_role_id']   = $token_data['data']['user_role_id'];
        $token_data['user_name']      = $token_data['data']['user_name'];
        $token_data['karigar_id']    = $token_data['data']['karigar_id'];
        $token_data['karigar_name']    = $token_data['data']['karigar_name'];
        $token_data['process_id']    = $token_data['data']['process_id'];
        $token_data['process_name']    = $token_data['data']['process_name'];
        $token_data['fin_year']       = $token_data['data']['fin_year'];
        $token_data['start_year']     = $token_data['data']['start_year'];
        $token_data['end_year']       = $token_data['data']['end_year'];   
        $token_data['time']           = strtotime('+2 days');

        $user_token = $this->validatetoken->generateToken($token_data);
        if($this->db_operations->data_update('user_master',['user_token_auth'=>$user_token],'user_id',$user_id)<1){
            $message = [
                'status' => FALSE,
                'message' => "Token not generated."
            ];
            $this->response($message, REST_Controller::HTTP_OK);
            return;
        }
        $message = [
            'status'    => true,
            'data'      => $user_token,
            'message'   => "success"
        ];
        $this->response($message, REST_Controller::HTTP_OK);
    }

    public function user_fcm_token_update_post(){
        header("Access-Control-Allow-Origin: *");
        
        $token_data = $this->validatetoken->middleware(['validateAccessKey','validateToken']);
        if($token_data['status']!==TRUE){
            $this->response($token_data, REST_Controller::HTTP_NOT_FOUND);
            return;
        }
        if($token_data['data']['isTeacher']!=1){
            $message = [
                'status' => FALSE,
                'message' => "Invalid request.."
            ];
            $this->response($message, REST_Controller::HTTP_OK);
            return;
        }
        $user_id = $token_data['data']['user_id'];

        $_POST = $this->security->xss_clean($_POST);
        $input_data = $this->input->raw_input_stream;
        $form_data = json_decode($input_data, true);
        
        $post_data = $form_data;
        if (empty($post_data)) {
            $message = [
                'status' => FALSE,
                'message' => "2. Invalid request.."
            ];
            $this->response($message, REST_Controller::HTTP_NOT_FOUND);
            return;
        }
        $_POST = $this->security->xss_clean($post_data);
        $this->form_validation->set_rules('token', 'TOKEN', 'trim|required');
        if ($this->form_validation->run() == FALSE)
        {
            // Form Validation Errors
            $message = array(
                'status' => FALSE,
                'error' => $this->form_validation->error_array(),
                'message' => validation_errors()
            );

            $this->response($message, REST_Controller::HTTP_NOT_FOUND);
            return;
        }
        if($this->db_operations->data_update('user_master',['user_token'=>$_POST['token']],'user_id',$_POST['id'])<1){
            $message = [
                'status' => FALSE,
                'message' => "Token not updated."
            ];
            $this->response($message, REST_Controller::HTTP_OK);
            return;
        }
        $resp = [
                'status'    => TRUE,
                'data'      => [],
                'message'   => "success"
            ];
        $this->response($resp, REST_Controller::HTTP_OK);    
    }

    public function get_designation_list_post()
    {   
        
        header("Access-Control-Allow-Origin: *");
        // $token_data = $this->validatetoken->middleware(['validateAccessKey','validateToken']);
        // // print_r($token_data);die;
        // if($token_data['status']!==TRUE){ 
        //     $this->response($token_data, REST_Controller::HTTP_NOT_FOUND);
        //     return;
        // }

        $_POST = $this->security->xss_clean($_POST);
        $input_data = $this->input->raw_input_stream;
        $form_data  = json_decode($input_data, true);
       
        $post_data = $form_data;
        // if (empty($post_data)) { 
        //     $message = ['status' => FALSE,'message' => "2. Invalid request.."];
        //     $this->response($message, REST_Controller::HTTP_NOT_FOUND);
        //     return;
        // }

        $_POST = $this->security->xss_clean($post_data); 
        $designation_name = (isset($_POST['designation_name']) && !empty($_POST['designation_name']))?$_POST['designation_name']:''; 
        $output = $this->UserModel->get_designation_list($designation_name);

        if(empty($output) || $output == FALSE)
        {
            $message = ['status' => FALSE,'message' => "No Record Available"];
            $this->response($message, REST_Controller::HTTP_OK);
            return;
        }

        $return_data = $output;

        $message = ['status'    => true,'data' => $return_data,'message'   => "Record ferched successfully"];
        $this->response($message, REST_Controller::HTTP_OK);
    }

    public function get_karigar_list_post()
    {
        
        // header("Access-Control-Allow-Origin: *");
        //  $token_data = $this->validatetoken->middleware(['validateAccessKey','validateToken']);
        // // print_r($token_data);die;
        // if($token_data['status']!==TRUE){ 
        //     $this->response($token_data, REST_Controller::HTTP_NOT_FOUND);
        //     return;
        // }

        $_POST = $this->security->xss_clean($_POST);
        $input_data = $this->input->raw_input_stream;
        $form_data  = json_decode($input_data, true);
       
        $post_data = $form_data;
        if (empty($post_data)) { 
            $message = ['status' => FALSE,'message' => "2. Invalid request.."];
            $this->response($message, REST_Controller::HTTP_NOT_FOUND);
            return;
        }

        $_POST = $this->security->xss_clean($post_data);
        $this->form_validation->set_rules('process_id', 'Process', 'trim|required');
        if ($this->form_validation->run() == FALSE)
        {
            // Form Validation Errors
            $message = array(
                'status' => false,
                'error' => $this->form_validation->error_array(),
                'message' => validation_errors()
            );
            $this->response($message, REST_Controller::HTTP_OK);
            return;
        }
        
        $output = $this->UserModel->get_karigar_list($_POST['process_id']);
        if(empty($output) || $output == FALSE)
        {
            $message = ['status' => FALSE,'message' => "No Record Available"];
            $this->response($message, REST_Controller::HTTP_OK);
            return;
        }

        $return_data = $output;

        $message = ['status'    => true,'data' => $return_data,'message'   => "Record ferched successfully"];
        $this->response($message, REST_Controller::HTTP_OK);
    }



    
/*CI controller end*/    
}?>