<?php
	
	if (!function_exists('assets'))
	{
		function assets($path = '')
		{
			return base_url()."public/assets/".$path;
		}
	}

	if (!function_exists('sessionExist'))
	{
		function sessionExist()
		{
			$CI =& get_instance();
			return ($CI->session->userdata('user_id')) ? true : false;
			// return ($CI->session->userdata('user_id') && $CI->session->userdata('key')) ? true : false;
    	}
	}

	if (!function_exists('encrypt_decrypt')) 
	{
		function encrypt_decrypt($action, $data, $secret_key) 
		{
		    $output         = false;
		    $encrypt_method = "AES-256-CBC";
		    $secret_iv      = $secret_key;
		    $key            = hash('sha256', $secret_key);
		    $iv             = substr(hash('sha256', $secret_iv), 0, 16);

		    if ($action == 'encrypt') 
		    {
		        $output = openssl_encrypt($data, $encrypt_method, $key, 0, $iv);
		        $output = base64_encode($output);
		    } 
		    else if ($action == 'decrypt') 
		    {
		        $output = openssl_decrypt(base64_decode($data), $encrypt_method, $key, 0, $iv);
		    }

		    return $output;
		}
	}

	if (!function_exists('number_to_word'))
	{
		function number_to_word( $num = '' )
	    {
	        $num    = ( string ) ( ( int ) $num );
	       
	        if( ( int ) ( $num ) && ctype_digit( $num ) )
	        {
	            $words  = array( );
	           
	            $num    = str_replace( array( ',' , ' ' ) , '' , trim( $num ) );
	           
	            $list1  = array('','one','two','three','four','five','six','seven',
	                'eight','nine','ten','eleven','twelve','thirteen','fourteen',
	                'fifteen','sixteen','seventeen','eighteen','nineteen');
	           
	            $list2  = array('','ten','twenty','thirty','forty','fifty','sixty',
	                'seventy','eighty','ninety','hundred');
	           
	            $list3  = array('','thousand','million','billion','trillion',
	                'quadrillion','quintillion','sextillion','septillion',
	                'octillion','nonillion','decillion','undecillion',
	                'duodecillion','tredecillion','quattuordecillion',
	                'quindecillion','sexdecillion','septendecillion',
	                'octodecillion','novemdecillion','vigintillion');
	           
	            $num_length = strlen( $num );
	            $levels = ( int ) ( ( $num_length + 2 ) / 3 );
	            $max_length = $levels * 3;
	            $num    = substr( '00'.$num , -$max_length );
	            $num_levels = str_split( $num , 3 );
	           
	            foreach( $num_levels as $num_part )
	            {
	                $levels--;
	                $hundreds   = ( int ) ( $num_part / 100 );
	                $hundreds   = ( $hundreds ? ' ' . $list1[$hundreds] . ' Hundred' . ( $hundreds == 1 ? '' : 's' ) . ' ' : '' );
	                $tens       = ( int ) ( $num_part % 100 );
	                $singles    = '';
	               
	                if( $tens < 20 )
	                {
	                    $tens   = ( $tens ? ' ' . $list1[$tens] . ' ' : '' );
	                }
	                else
	                {
	                    $tens   = ( int ) ( $tens / 10 );
	                    $tens   = ' ' . $list2[$tens] . ' ';
	                    $singles    = ( int ) ( $num_part % 10 );
	                    $singles    = ' ' . $list1[$singles] . ' ';
	                }
	                $words[]    = $hundreds . $tens . $singles . ( ( $levels && ( int ) ( $num_part ) ) ? ' ' . $list3[$levels] . ' ' : '' );
	            }
	           
	            $commas = count( $words );
	           
	            if( $commas > 1 )
	            {
	                $commas = $commas - 1;
	            }
	           
	            $words  = implode( ', ' , $words );
	           
	            //Some Finishing Touch
	            //Replacing multiples of spaces with one space
	            $words  = trim( str_replace( ' ,' , ',' , trim_all( ucwords( $words ) ) ) , ', ' );
	            if( $commas )
	            {
	                $words  = str_replace_last( ',' , ' and' , $words );
	            }
	           
	            return $words;
	        }
	        else if( ! ( ( int ) $num ) )
	        {
	            return 'Zero';
	        }
	        return '';
	    }
	}


	if (!function_exists('trim_all'))
	{	
		function trim_all( $str , $what = NULL , $with = ' ' )
	    {
	        if( $what === NULL )
	        {
	            //  Character      Decimal      Use
	            //  "\0"            0           Null Character
	            //  "\t"            9           Tab
	            //  "\n"           10           New line
	            //  "\x0B"         11           Vertical Tab
	            //  "\r"           13           New Line in Mac
	            //  " "            32           Space
	           
	            $what   = "\\x00-\\x20";    //all white-spaces and control chars
	        }
	       
	        return trim( preg_replace( "/[".$what."]+/" , $with , $str ) , $what );
	    }
	}

    if (!function_exists('str_replace_last'))
	{
		function str_replace_last( $search , $replace , $str ) 
	    {
			if( ( $pos = strrpos( $str , $search ) ) !== false ) {
			    $search_length  = strlen( $search );
			    $str    = substr_replace( $str , $replace , $pos , $search_length );
			}
			return $str;
	    }
	}

// 	if (!function_exists('send_whatsapp')){  
// 		function send_whatsapp($mob, $msg = '', $path = '', $filename = '.'){
// 			$instanceid = "cmfdiel621mng13seyzzdxgt2";
// 			$mob = "919763432458";
// 			$msg = urlencode($msg);
//         	if(strpos(trim($mob),"+91")===false || strlen(trim($mob))==10){
// 				$mob = "91".$mob;
// 			}
			
// 			$url = "https://enotify.app/api/sendText?token=$instanceid&phone=$mob&message=$msg";  
// 			$output = json_decode(@file_get_contents($url), true);
// 			return (isset($output['status']) && $output['status'] == 'success') ? ['status' => TRUE, 'data' => TRUE, 'msg' => 'Whatsapp message send successfully'] : ['status' => FALSE, 'data' => FALSE, 'msg' =>''] ;
// 		}
// 	}
	if (!function_exists('send_whatsapp')){   
		function send_whatsapp($mob, $msg,$link='',$api_type=''){  
			$instanceid = "cmfdiel621mng13seyzzdxgt2";
			$msg = urlencode($msg);
        	if(strlen(trim($mob))==10){
				$mob = "91".$mob;
			}else if(strpos(trim($mob),"+91")==false){
				$mob = str_replace('+91','91',$mob);
			}

			$api_type = (isset($api_type) && !empty($api_type))? $api_type: 'sendText';
// 			$mob = "919763432458";
            // $mob = "919819741591";
			$url = 'https://enotify.app/api/';
			$url .= $api_type;
			$url.= '?token='.$instanceid;
			$url.= '&phone='.$mob;
			$url.= '&message='.$msg;
			if(isset($link) && !empty($link)) $url .= '&link='.$link;
// 			echo $url; exit();

			$output = json_decode(@file_get_contents($url), true);
			// $msg = (isset($output['status']) && $output['status'] == 'success' && $output['message'] != 'Insufficient credit') ? 'Whatsapp msg send successfully.' : (isset($output['message']) ? $output['message'] : 'Bad request');
			
			// return (isset($output['status']) && $output['status'] == 'success' && $output['message'] != 'Insufficient credit') ? ['status' => TRUE, 'data' => TRUE, 'msg' => $msg] : ['status' => FALSE, 'data' => FALSE, 'msg' =>$msg];

			$msg = 'Bad request';
			$status = FALSE;
			// Check if response is valid and successful
			if (isset($output['status']) && $output['status'] === 'success') {
			    if ($output['message'] === 'Insufficient credit') {
			        $msg = 'Insufficient credit';
			    } else {
			        $msg = 'Whatsapp msg sent successfully.';
			        $status = TRUE;
			    }
			} elseif (isset($output['message'])) {
			    $msg = $output['message'];
			}

			return [
			    'status' => $status,
			    'data' => $status,
			    'msg'   => $msg
			];
			
		}
	}

?>